
// SC540N1_WebRTCDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC540N1_WebRTC.h"
#include "SC540N1_WebRTCDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CSC540N1_WebRTCDlg  * g_main_webRTCDlg = NULL;

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CSC540N1_WebRTCDlg* m_pMainDialog = (CSC540N1_WebRTCDlg * ) pUserData;

	m_pMainDialog->m_nDeviceVideoWidth = 0;

	m_pMainDialog->m_nDeviceVideoHeight = 0;

	m_pMainDialog->m_bDeviceVideoIsInterleaved = FALSE;

	m_pMainDialog->m_dDeviceVideoFrameRate = 0.0;

	m_pMainDialog->m_nDeviceAudioChannel = 0;

	m_pMainDialog->m_nDeviceAudioBitsPerSample = 0;

	m_pMainDialog->m_nDeviceAudioSampleFrequency = 0;

	SC_DEBUG( "on_no_signal_detected_callback()" );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CSC540N1_WebRTCDlg* m_pMainDialog = (CSC540N1_WebRTCDlg * ) pUserData;

	m_pMainDialog->m_nDeviceVideoWidth = 0;

	m_pMainDialog->m_nDeviceVideoHeight = 0;

	m_pMainDialog->m_bDeviceVideoIsInterleaved = FALSE;

	m_pMainDialog->m_dDeviceVideoFrameRate = 0.0;

	m_pMainDialog->m_nDeviceAudioChannel = 0;

	m_pMainDialog->m_nDeviceAudioBitsPerSample = 0;

	m_pMainDialog->m_nDeviceAudioSampleFrequency = 0;

	SC_DEBUG( "on_no_signal_removed_callback()" );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CSC540N1_WebRTCDlg* m_pMainDialog = (CSC540N1_WebRTCDlg * ) pUserData;

	m_pMainDialog->m_nDeviceVideoWidth = nVideoWidth;

	m_pMainDialog->m_nDeviceVideoHeight = nVideoHeight;

	m_pMainDialog->m_bDeviceVideoIsInterleaved = bVideoIsInterleaved;

	m_pMainDialog->m_dDeviceVideoFrameRate = dVideoFrameRate;

	m_pMainDialog->m_nDeviceAudioChannel = nAudioChannels;

	m_pMainDialog->m_nDeviceAudioBitsPerSample = nAudioBitsPerSample;

	m_pMainDialog->m_nDeviceAudioSampleFrequency = nAudioSampleFrequency;

	SC_DEBUG( "on_format_changed_callback( %d, %d, %d, %2.3f, %d, %d, %d )", nVideoWidth, nVideoHeight, bVideoIsInterleaved, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );
	
	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CSC540N1_WebRTCDlg * m_pMainDialog = (CSC540N1_WebRTCDlg * )(pUserData);

	static int count = 0;
	
    if( m_pMainDialog->m_nShareRecordState ) {

    	char buffer[ 64 ];
    
    	sprintf( buffer, "%d", m_pMainDialog->m_chatter_id % CHATROOM_USER_MAX_NUM );
    
    	count++;
    
    	QCAP_SET_OSD_TEXT( m_pMainDialog->m_pDevice,  0, 0, 0, 0, 0, buffer, "Arial",  QCAP_FONT_STYLE_BOLD, 120, 0xFFFFFFFF, 0x00FF0000, 0xFF, 0, 0 );
    
    	QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0,         														  
    												      QCAP_COLORSPACE_TYEP_YV12,         		
    												      m_pMainDialog->m_nDeviceVideoWidth,         														  
    												      m_pMainDialog->m_nDeviceVideoHeight,        														  
    												      pFrameBuffer,        														  
    												      nFrameBufferLen );
    }

    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CSC540N1_WebRTCDlg * m_pMainDialog = (CSC540N1_WebRTCDlg * )(pUserData);

    if( m_pMainDialog->m_nShareRecordState ) {

	    QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );														  
	}
    return QCAP_RT_OK;
}


QRETURN on_share_record_video_encode_callback( UINT iRecNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CSC540N1_WebRTCDlg * m_pMainDialog = (CSC540N1_WebRTCDlg * )(pUserData);

    for ( ULONG i = 0 ; i < CHATROOM_USER_MAX_NUM ; i ++ ) {

	    if( m_pMainDialog->m_nStartChatState[ i ] >= 0x00000001 ) {

        	QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( m_pMainDialog->m_pSender[ i ], 0, pStreamBuffer, nStreamBufferLen, bIsKeyFrame);
        }
	}
    return QCAP_RT_OK;
}

QRETURN on_share_record_audio_encode_callback( UINT iRecNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, PVOID pUserData )
{
	CSC540N1_WebRTCDlg * m_pMainDialog = (CSC540N1_WebRTCDlg * )(pUserData);

    for( ULONG i = 0 ; i < CHATROOM_USER_MAX_NUM ; i ++ ) {

		if( m_pMainDialog->m_nStartChatState[i] >= 0x00000001 ) {
			
			QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER( m_pMainDialog->m_pSender[ i ], 0, pStreamBuffer, nStreamBufferLen );												
		 }
	}
    return QCAP_RT_OK;
}

QRETURN on_webrtc_peer_connect_callback( PVOID pChatter, ULONG nPeerID, QRESULT nConnectionStatus, PVOID pUserData )
{	
	ULONG idx = (ULONG)(pUserData);

	EnterCriticalSection( &g_main_webRTCDlg->m_hNetworkServerAccessCriticalSections );	

	g_main_webRTCDlg->m_nConnect_count++;

	if( nConnectionStatus == QCAP_RS_SUCCESSFUL ) {

		if ( g_main_webRTCDlg->m_bConnectionState == FALSE ) {

			g_main_webRTCDlg->SetTimer(0x00000001, 1, NULL);
		}

		if (g_main_webRTCDlg->m_nConnect_count % (CHATROOM_USER_MAX_NUM - 1) == 0)
		{
			g_main_webRTCDlg->SetTimer(0x00000002, 1, NULL);
		}	
	}

	LeaveCriticalSection( &g_main_webRTCDlg->m_hNetworkServerAccessCriticalSections );	

	return QCAP_RT_OK;
}


QRETURN on_webrtc_peer_disconnect_callback( PVOID pChatter, ULONG nPeerID, PVOID pUserData )
{	
	ULONG idx = (ULONG)(pUserData);

	EnterCriticalSection( &g_main_webRTCDlg->m_hNetworkServerAccessCriticalSections );	

	g_main_webRTCDlg->m_nDisconnect_count++;

	if ( g_main_webRTCDlg->m_bConnectionState == TRUE ) {

		g_main_webRTCDlg->SetTimer(0x00000003, 1, NULL);
	}

	if (g_main_webRTCDlg->m_nDisconnect_count % (CHATROOM_USER_MAX_NUM - 1) == 0)
	{
		g_main_webRTCDlg->SetTimer( 0x00000004, 1, NULL );
	}

	LeaveCriticalSection( &g_main_webRTCDlg->m_hNetworkServerAccessCriticalSections );	

	return QCAP_RT_OK;
}

QRETURN on_webrtc_client_video_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	return QCAP_RT_OK;
}

QRETURN on_webrtc_client_video_decode_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{	
	return QCAP_RT_OK;
}


class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CSC540N1_WebRTCDlg dialog


CSC540N1_WebRTCDlg::CSC540N1_WebRTCDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSC540N1_WebRTCDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSC540N1_WebRTCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_WINDOWS_PEER, m_windows_peer[0]);
	DDX_Control(pDX, IDC_WINDOWS_PEER2, m_windows_peer[1]);
	DDX_Control(pDX, IDC_WINDOWS_PEER3, m_windows_peer[2]);
	DDX_Control(pDX, IDC_WINDOWS_PEER4, m_windows_peer[3]);

	DDX_Control(pDX, IDC_WINDOWS_MAIN, m_windows_main);
	DDX_Control(pDX, IDC_LIST3, m_list_peer);
	DDX_Control(pDX, IDC_EDIT_NAME, m_edit_name);
	DDX_Control(pDX, IDC_EDIT_IP, m_edit_ip);
	DDX_Control(pDX, IDC_EDIT_PORT, m_edit_port);

}

BEGIN_MESSAGE_MAP(CSC540N1_WebRTCDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, &CSC540N1_WebRTCDlg::OnBnClickedButtonUpdate)
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, &CSC540N1_WebRTCDlg::OnBnClickedButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, &CSC540N1_WebRTCDlg::OnBnClickedButtonDisconnect)
	ON_BN_CLICKED(IDC_BUTTON_LOGIN, &CSC540N1_WebRTCDlg::OnBnClickedButtonLogin)
	ON_BN_CLICKED(IDC_BUTTON_LOGOUT, &CSC540N1_WebRTCDlg::OnBnClickedButtonLogout)

END_MESSAGE_MAP()


// CSC540N1_WebRTCDlg message handlers

BOOL CSC540N1_WebRTCDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

    GetDlgItem( IDC_BUTTON_LOGIN )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_LOGOUT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_UPDATE )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );

	// Create a mapping table account for connection relationship

	for ( ULONG i = 0 ; i < CHATROOM_USER_MAX_NUM; i++ ) {

		for ( ULONG j = 0 ; j < CHATROOM_USER_MAX_NUM; j++ ) {

			if ( i == j ) {

				m_MappingTable[i][j] = -1;	

			} else {

				m_MappingTable[i][j] = ( i + j - 1) % CHATROOM_USER_MAX_NUM; 				
			}
		}
	}

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	g_main_webRTCDlg = this;

	// INITIALIZE VARIABLE
	// 
	m_pDevice = NULL;

	m_nDeviceVideoWidth = 0;

	m_nDeviceVideoHeight = 0;

	m_bDeviceVideoIsInterleaved = FALSE;

	m_dDeviceVideoFrameRate = 0.0;

	m_nDeviceAudioChannel = 0;

	m_nDeviceAudioBitsPerSample= 0;

	m_nDeviceAudioSampleFrequency = 0;

	m_nShareRecordState = NULL;

	m_nConnect_count = 0;

	m_nDisconnect_count = 0;

	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSections);

	for ( ULONG i = 0 ; i < CHATROOM_USER_MAX_NUM ; i ++ )
	{
		m_pChatter[i] = NULL;

		m_pSender[i] = NULL;

		m_pReceiver[i] = NULL;

		m_nStartChatState[i] = 0x00000000;

		m_bConnectionState = false; 

	}

	srand(time(0));

	sprintf( m_chatter_username, "default%02d", rand()%100 );

	m_edit_name.SetWindowText(m_chatter_username);

	m_edit_ip.SetWindowText("127.0.0.1");

	m_edit_port.SetWindowText("8888");

	// INITIALIZE DEVICE RESOURCE
	// 
	QCAP_CREATE( "QP0203 PCI", 0, m_windows_main.m_hWnd, &m_pDevice, TRUE, FALSE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_format_changed_callback, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_no_signal_detected_callback, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_no_signal_removed_callback, this );

	QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

	QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

	QCAP_RUN( m_pDevice );

	QCAP_SET_AUDIO_VOLUME(m_pDevice , 0);


	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC540N1_WebRTCDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC540N1_WebRTCDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC540N1_WebRTCDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CSC540N1_WebRTCDlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	// TODO: Add your message handler code here
	if ( m_bConnectionState ) {

		OnBnClickedButtonDisconnect();
	}

	if ( m_nShareRecordState ) {

		QCAP_STOP_SHARE_RECORD( 0 );
			
		m_nShareRecordState = false;
	}

	for ( ULONG i = 0 ; i< CHATROOM_USER_MAX_NUM ; i++ ) {

        m_nStartChatState[ i ] = 0x00000000;        

        if( m_pChatter[ i ] ) {
        
        	QCAP_DESTROY_WEBRTC_CHATTER( m_pChatter[ i ] );
        
        	m_pChatter[ i ] = NULL;
        }

        if( m_pSender[ i ] ) {
        
        	QCAP_STOP_BROADCAST_SERVER( m_pSender[ i ] );
        
        	QCAP_DESTROY_BROADCAST_SERVER( m_pSender[ i ] );
        
        	m_pSender[ i ] = NULL;
        }
        
        if( m_pReceiver[ i ] ) {
        
        	QCAP_STOP_BROADCAST_CLIENT( m_pReceiver[ i ] );
        
        	QCAP_DESTROY_BROADCAST_CLIENT( m_pReceiver[ i ] );
        
        	m_pReceiver[ i ] = NULL;
        }   
	}

	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSections );

	// UNINITIALIZE DEVICE RESOURCE
	// 
	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CSC540N1_WebRTCDlg::OnBnClickedButtonUpdate()
{
	// TODO: Add your control notification handler code here

	ULONG user_count = 0, n_peer_id = 0;

	CHAR *psz_peer_name;//[ MAX_PATH ];

	CHAR peer_column_tmp[ MAX_PATH ];

	memset(peer_column_tmp, 0x00, sizeof(peer_column_tmp) );
	
	m_list_peer.ResetContent();
	 
	QRESULT returns = QCAP_ENUM_WEBRTC_USER_IN_CHATROOM( m_pChatter[ 0 ], &n_peer_id, &psz_peer_name, FALSE );

	//SC_DEBUG( "QCAP_ENUM_WEBRTC_USER_IN_CHATROOM rs %u, n_peer_id : %u, psz_peer_name %s", returns, n_peer_id, psz_peer_name );

	sprintf(peer_column_tmp, "%u, %s", n_peer_id, psz_peer_name );

	if  (returns == QCAP_RS_SUCCESSFUL )
	{
		m_list_peer.AddString( peer_column_tmp);

		m_PeerTable[ n_peer_id % CHATROOM_USER_MAX_NUM ] = n_peer_id;

		user_count ++;
    }

	while( returns == QCAP_RS_SUCCESSFUL ) {

		returns = QCAP_ENUM_WEBRTC_USER_IN_CHATROOM( m_pChatter[ 0 ], &n_peer_id, &psz_peer_name, TRUE );		

		if  (returns == QCAP_RS_SUCCESSFUL )
		{
		    //SC_DEBUG( "QCAP_ENUM_WEBRTC_USER_IN_CHATROOM rs %u, n_peer_id : %u, psz_peer_name %s", returns, n_peer_id, psz_peer_name );

			memset(peer_column_tmp, 0x00, sizeof(peer_column_tmp) );
			
			sprintf(peer_column_tmp, "%u, %s", n_peer_id, psz_peer_name );			

			m_list_peer.AddString( peer_column_tmp);

			m_PeerTable[ n_peer_id % CHATROOM_USER_MAX_NUM ] = n_peer_id;

			user_count ++;
		}
	}

	m_PeerTable[ m_chatter_id % CHATROOM_USER_MAX_NUM ] = m_chatter_id;
}


void CSC540N1_WebRTCDlg::OnBnClickedButtonConnect()
{
	// TODO: Add your control notification handler code here	

	// |I\J| 0 | 1 | 2 | 3 |
	// | 0 | X | 0 | 1 | 2 |
	// | 1 |   | X | 2 | 3 |
	// | 2 |       | X | 0 |
	// | 3 |           | X |
	//
	ULONG i = m_chatter_id % CHATROOM_USER_MAX_NUM;

	for( ULONG j = 0 ; j < CHATROOM_USER_MAX_NUM ; j++ ) {
	
		if( j <= i ) { continue ; }

		int port = m_MappingTable[ i ][ j ];

		QRESULT res = QCAP_START_WEBRTC_CHAT( m_pChatter[ port ], m_PeerTable[ j ] );
	}
	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( FALSE );

	m_bConnectionState = TRUE;
}

void CSC540N1_WebRTCDlg::OnBnClickedButtonDisconnect()
{
	// TODO: Add your control notification handler code here
	
	// |I\J| 0 | 1 | 2 | 3 |
	// | 0 | X | 0 | 1 | 2 |
	// | 1 |   | X | 2 | 3 |
	// | 2 |       | X | 0 |
	// | 3 |           | X |
	//
	ULONG i = m_chatter_id % CHATROOM_USER_MAX_NUM;

	for ( ULONG j = 0 ; j < CHATROOM_USER_MAX_NUM ; j++ ) {
	
		if( j <= i ) { continue ; }

		int port = m_MappingTable[ i ][ j ];

		QRESULT res = QCAP_STOP_WEBRTC_CHAT( m_pChatter[ port ] );
	}

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );

	m_bConnectionState = FALSE;
}

void CSC540N1_WebRTCDlg::OnTimer( UINT_PTR nIDEvent )
{
	// TODO: Add your message handler code here and/or call default	

	if( nIDEvent == 0x00000001 ) {

		KillTimer( 0x00000001 );

		EnterCriticalSection( &m_hNetworkServerAccessCriticalSections );

		if( m_bConnectionState == FALSE ) {

			OnBnClickedButtonUpdate();

			OnBnClickedButtonConnect();
		} 
		
		LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections );
	}

	if ( nIDEvent == 0x00000002 ) {

		KillTimer ( 0x00000002 );

		EnterCriticalSection( &m_hNetworkServerAccessCriticalSections );

		GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( FALSE );

		GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( TRUE );

		LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections );
	}

	if( nIDEvent == 0x00000003 ) {

		KillTimer( 0x00000003 );

		EnterCriticalSection( &m_hNetworkServerAccessCriticalSections );

		if( m_bConnectionState == TRUE ) {

			OnBnClickedButtonUpdate();

			OnBnClickedButtonDisconnect();
		} 
		
		LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections );
	}

	if ( nIDEvent == 0x00000004 ) {

		KillTimer ( 0x00000004 );

		EnterCriticalSection( &m_hNetworkServerAccessCriticalSections );

		GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( TRUE );

		GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );

		LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections );
	}

	CDialogEx::OnTimer( nIDEvent );
}


void CSC540N1_WebRTCDlg::OnBnClickedButtonLogin()
{
	// TODO: Add your control notification handler code here
		
	CString username, chatroom_ip, chatroom_port;	

	m_edit_name.GetWindowTextA(username);

	m_edit_ip.GetWindowTextA(chatroom_ip);

	m_edit_port.GetWindowTextA(chatroom_port);

	memset( m_chatter_username , 0x00 , sizeof(m_chatter_username));

	sprintf( m_chatter_username, "%s", username );

	double  fps = m_dDeviceVideoFrameRate; if( m_bDeviceVideoIsInterleaved ) { fps /= 2; }

    if ( m_nShareRecordState == NULL ) {

		QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM, m_nDeviceAudioChannel, m_nDeviceAudioBitsPerSample, m_nDeviceAudioSampleFrequency );	

		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, 720, 480, 30, QCAP_RECORD_MODE_CBR, 8000, 2 * 1024 * 1024, 30, 0, 0, 0, 0 );

		QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK( 0, on_share_record_video_encode_callback, this);

		QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK( 0, on_share_record_audio_encode_callback, this);

		QCAP_START_SHARE_RECORD( 0, "", QCAP_RECORD_FLAG_ENCODE  );

		m_nShareRecordState = true;
	}

	for( ULONG i = 0 ; i < CHATROOM_USER_MAX_NUM ; i++ ) {

		QCAP_CREATE_WEBRTC_CHATTER( chatroom_ip.GetBuffer( 0 ), atoi(chatroom_port) + i, username.GetBuffer( 0 ), &m_pChatter[ i ] , &m_chatter_id );

	    QCAP_REGISTER_WEBRTC_PEER_CONNECTED_CALLBACK( m_pChatter[ i ], on_webrtc_peer_connect_callback, (PVOID)(i) );
    
        QCAP_REGISTER_WEBRTC_PEER_DISCONNECTED_CALLBACK( m_pChatter[ i ], on_webrtc_peer_disconnect_callback , (PVOID)(i) );

		if( m_pReceiver[ i ] == NULL ) {

			QCAP_CREATE_WEBRTC_RECEIVER( m_pChatter[ i ], i, &m_pReceiver[ i ], QCAP_ENCODER_TYPE_SOFTWARE, m_windows_peer[ i ].m_hWnd, TRUE, FALSE );

			if( m_pReceiver[ i ] ) {
			
				QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( m_pReceiver[ i ], on_webrtc_client_video_callback, (PVOID)(i) );

				QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK( m_pReceiver[ i ], on_webrtc_client_video_decode_callback, (PVOID)(i) );

				QCAP_START_BROADCAST_CLIENT( m_pReceiver[ i ] );

				QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME( m_pReceiver[ i ], 0, 0 );			
			}
		}
	}
	
	QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME( m_pReceiver[ 0 ], 0, 100 );

	for ( ULONG i = 0 ; i< CHATROOM_USER_MAX_NUM ; i++ ) {

		if( m_pSender[i] == NULL ) {

			QCAP_CREATE_WEBRTC_SENDER( m_pChatter[ i ] , i, &m_pSender[ i ]  );

			if( m_pSender[i] ) {

                QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_pSender[ i ], 						
                									               0, 															 
                									               QCAP_ENCODER_TYPE_SOFTWARE, 															  
                								                   QCAP_ENCODER_FORMAT_H264, 															  
                								                   QCAP_COLORSPACE_TYEP_YV12, 															  
                								                   720, 
                								                   480,															  
                								                   fps, 															  
                								                   QCAP_RECORD_MODE_CBR, 															  
                								                   8000, 															  
                								                   2 * 1024 * 1024, 															  
                								                   30,  															  
                								                   0,  0, 															  
                								                   NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_NETWORK ); 
               
                QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_pSender[ i ], 						
                									               0, 															  
                		                                           QCAP_ENCODER_TYPE_SOFTWARE, 															  
                									               QCAP_ENCODER_FORMAT_PCM, 															  
                									               m_nDeviceAudioChannel, 															  
                									               m_nDeviceAudioBitsPerSample, 															  
                									               m_nDeviceAudioSampleFrequency );
                
		    	QCAP_START_BROADCAST_SERVER( m_pSender[ i ] );

	    	}

		    m_nStartChatState[ i ] = 0x00000001;
	    }
	}

    GetDlgItem( IDC_BUTTON_LOGIN )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_LOGOUT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_UPDATE )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );
}


void CSC540N1_WebRTCDlg::OnBnClickedButtonLogout()
{
	// TODO: Add your control notification handler code here

	if ( m_bConnectionState ) {

		OnBnClickedButtonDisconnect();
	}

	if ( m_nShareRecordState ) {

		QCAP_STOP_SHARE_RECORD( 0 );

		m_nShareRecordState = false;
	}

	for ( ULONG i = 0 ; i< CHATROOM_USER_MAX_NUM ; i++ ) {

        m_nStartChatState[ i ] = 0x00000000;
        
        if( m_pChatter[ i ] ) {
        
        	QCAP_DESTROY_WEBRTC_CHATTER( m_pChatter[ i ] );
        
        	m_pChatter[ i ] = NULL;
        }
        
        if( m_pSender[ i ] ) {
        
        	QCAP_STOP_BROADCAST_SERVER( m_pSender[ i ] );
        
        	QCAP_DESTROY_BROADCAST_SERVER( m_pSender[ i ] );
        
        	m_pSender[ i ] = NULL;
        }
        
        if( m_pReceiver[ i ] ) {
        
        	QCAP_STOP_BROADCAST_CLIENT( m_pReceiver[ i ] );
        
        	QCAP_DESTROY_BROADCAST_CLIENT( m_pReceiver[ i ] );
        
        	m_pReceiver[ i ] = NULL;
        }        
	}

    GetDlgItem( IDC_BUTTON_LOGIN )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_LOGOUT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_UPDATE )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );
}


